public class Tablica {
  private Object tab[];
  Tablica(int size){
    tab = new Object[size];
  }
  public Object get(int index){
    if(index >= tab.length || index < 0){
      throw new ArrayIndexOutOfBoundsException("index = " + index);
    }
    else{
      return tab[index];
    }
  }
  public void set(int index, Object value){
    if(index < 0){
      throw new ArrayIndexOutOfBoundsException("index = " + index);
    }
    if(index >= tab.length){
      resize(index + 1);
    }
    tab[index] = value;
  }
  protected void resize(int size){
    Object newTab[] = new Object[size];
    for(int i = 0; i < tab.length; i++){
      newTab[i] = tab[i];
    }
    tab = newTab;
  }
  public int size(){
    return tab.length;
  }

  public static void main(String args[]){
    Tablica tab = new Tablica(2);
    tab.set(0, 1);
    tab.set(1, 2);
    tab.set(2, new Object());
    for(int i = 0; i < tab.size(); i++){
      System.out.println("tab[" + i + "] = " + tab.get(i) + " ");
    }
    tab.get(3);
  }
}
